/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptTransformer
extends Transformer {
    private Object engine;
    private Method invokeFunctionMethod;
    private String functionName;

    @Override
    public Object transformRow(Map<String, Object> row, Context context) {
        try {
            if (this.engine == null) {
                this.initEngine(context);
            }
            if (this.engine == null) {
                return row;
            }
            return this.invokeFunctionMethod.invoke(this.engine, this.functionName, new Object[]{row, context});
        }
        catch (DataImportHandlerException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Could not invoke method :" + this.functionName + "\n <script>\n" + context.getScript() + "</script>");
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Error invoking script for entity " + context.getEntityAttribute("name"));
        }
        return null;
    }

    private void initEngine(Context context) {
        String scriptText = context.getScript();
        String scriptLang = context.getScriptLanguage();
        if (scriptText == null) {
            throw new DataImportHandlerException(500, "<script> tag is not present under <dataConfig>");
        }
        Object scriptEngineMgr = null;
        Method evalMethod = null;
        try {
            scriptEngineMgr = Class.forName("javax.script.ScriptEngineManager").newInstance();
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "<script> can be used only in java 6 or above");
        }
        try {
            Method getEngineMethod = scriptEngineMgr.getClass().getMethod("getEngineByName", String.class);
            this.engine = getEngineMethod.invoke(scriptEngineMgr, scriptLang);
            evalMethod = this.engine.getClass().getMethod("eval", String.class);
            this.invokeFunctionMethod = this.engine.getClass().getMethod("invokeFunction", String.class, Object[].class);
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Cannot load Script Engine for language: " + scriptLang);
        }
        try {
            evalMethod.invoke(this.engine, scriptText);
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "'eval' failed with language: " + scriptLang + " and script: \n" + scriptText);
        }
    }

    public void setFunctionName(String methodName) {
        this.functionName = methodName;
    }

    public String getFunctionName() {
        return this.functionName;
    }
}

