/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Comparator;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.list.IntArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Partitioning {
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    protected static int steps = 0;

    private Partitioning() {
    }

    private static int binarySearchFromTo(int a, int from, int to, IntComparator comp) {
        while (from <= to) {
            int mid = (from + to) / 2;
            int comparison = comp.compare(mid, a);
            if (comparison < 0) {
                from = mid + 1;
                continue;
            }
            if (comparison > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static void dualPartition(double[] list, double[] secondary, int from, int to, double[] splitters, int splitFrom, int splitTo, int[] splitIndexes) {
        int i;
        int splitIndex;
        int medianIndex;
        if (splitFrom > splitTo) {
            return;
        }
        if (from > to) {
            --from;
            int i2 = splitFrom;
            while (i2 <= splitTo) {
                splitIndexes[i2++] = from;
            }
            return;
        }
        if (splitFrom == splitTo) {
            medianIndex = splitFrom;
        } else {
            int m = (from + to) / 2;
            int len = to - from + 1;
            if (len > 7) {
                int l = from;
                int n = to;
                if (len > 40) {
                    int s = len / 8;
                    l = Partitioning.med3(list, l, l + s, l + 2 * s);
                    m = Partitioning.med3(list, m - s, m, m + s);
                    n = Partitioning.med3(list, n - 2 * s, n - s, n);
                }
                m = Partitioning.med3(list, l, m, n);
            }
            if ((medianIndex = Sorting.binarySearchFromTo((double[])splitters, (double)list[m], (int)splitFrom, (int)splitTo)) < 0) {
                medianIndex = -medianIndex - 1;
            }
            if (medianIndex > splitTo) {
                medianIndex = splitTo;
            }
        }
        double splitter = splitters[medianIndex];
        splitIndexes[medianIndex] = splitIndex = Partitioning.dualPartition(list, secondary, from, to, splitter);
        if (splitIndex < from) {
            i = medianIndex - 1;
            while (i >= splitFrom && !(splitter < splitters[i])) {
                splitIndexes[i--] = splitIndex;
            }
            splitFrom = medianIndex + 1;
        } else if (splitIndex >= to) {
            i = medianIndex + 1;
            while (i <= splitTo && !(splitter > splitters[i])) {
                splitIndexes[i++] = splitIndex;
            }
            splitTo = medianIndex - 1;
        }
        if (splitFrom <= medianIndex - 1) {
            Partitioning.dualPartition(list, secondary, from, splitIndex, splitters, splitFrom, medianIndex - 1, splitIndexes);
        }
        if (medianIndex + 1 <= splitTo) {
            Partitioning.dualPartition(list, secondary, splitIndex + 1, to, splitters, medianIndex + 1, splitTo, splitIndexes);
        }
    }

    public static int dualPartition(double[] list, double[] secondary, int from, int to, double splitter) {
        int i = from - 1;
        while (++i <= to) {
            double element = list[i];
            if (!(element < splitter)) continue;
            list[i] = list[from];
            list[from] = element;
            element = secondary[i];
            secondary[i] = secondary[from];
            secondary[from++] = element;
        }
        return from - 1;
    }

    public static void dualPartition(int[] list, int[] secondary, int from, int to, int[] splitters, int splitFrom, int splitTo, int[] splitIndexes) {
        int i;
        int splitIndex;
        int medianIndex;
        if (splitFrom > splitTo) {
            return;
        }
        if (from > to) {
            --from;
            int i2 = splitFrom;
            while (i2 <= splitTo) {
                splitIndexes[i2++] = from;
            }
            return;
        }
        if (splitFrom == splitTo) {
            medianIndex = splitFrom;
        } else {
            int m = (from + to) / 2;
            int len = to - from + 1;
            if (len > 7) {
                int l = from;
                int n = to;
                if (len > 40) {
                    int s = len / 8;
                    l = Partitioning.med3(list, l, l + s, l + 2 * s);
                    m = Partitioning.med3(list, m - s, m, m + s);
                    n = Partitioning.med3(list, n - 2 * s, n - s, n);
                }
                m = Partitioning.med3(list, l, m, n);
            }
            if ((medianIndex = Sorting.binarySearchFromTo((int[])splitters, (int)list[m], (int)splitFrom, (int)splitTo)) < 0) {
                medianIndex = -medianIndex - 1;
            }
            if (medianIndex > splitTo) {
                medianIndex = splitTo;
            }
        }
        int splitter = splitters[medianIndex];
        splitIndexes[medianIndex] = splitIndex = Partitioning.dualPartition(list, secondary, from, to, splitter);
        if (splitIndex < from) {
            i = medianIndex - 1;
            while (i >= splitFrom && splitter >= splitters[i]) {
                splitIndexes[i--] = splitIndex;
            }
            splitFrom = medianIndex + 1;
        } else if (splitIndex >= to) {
            i = medianIndex + 1;
            while (i <= splitTo && splitter <= splitters[i]) {
                splitIndexes[i++] = splitIndex;
            }
            splitTo = medianIndex - 1;
        }
        if (splitFrom <= medianIndex - 1) {
            Partitioning.dualPartition(list, secondary, from, splitIndex, splitters, splitFrom, medianIndex - 1, splitIndexes);
        }
        if (medianIndex + 1 <= splitTo) {
            Partitioning.dualPartition(list, secondary, splitIndex + 1, to, splitters, medianIndex + 1, splitTo, splitIndexes);
        }
    }

    public static int dualPartition(int[] list, int[] secondary, int from, int to, int splitter) {
        int i = from - 1;
        while (++i <= to) {
            int element = list[i];
            if (element >= splitter) continue;
            list[i] = list[from];
            list[from] = element;
            element = secondary[i];
            secondary[i] = secondary[from];
            secondary[from++] = element;
        }
        return from - 1;
    }

    public static void genericPartition(int from, int to, int splitFrom, int splitTo, int[] splitIndexes, IntComparator comp, IntComparator comp2, IntComparator comp3, Swapper swapper) {
        int i;
        int splitIndex;
        int medianIndex;
        if (splitFrom > splitTo) {
            return;
        }
        if (from > to) {
            --from;
            int i2 = splitFrom;
            while (i2 <= splitTo) {
                splitIndexes[i2++] = from;
            }
            return;
        }
        if (splitFrom == splitTo) {
            medianIndex = splitFrom;
        } else {
            int m = (from + to) / 2;
            int len = to - from + 1;
            if (len > 7) {
                int l = from;
                int n = to;
                if (len > 40) {
                    int s = len / 8;
                    l = Partitioning.med3(l, l + s, l + 2 * s, comp2);
                    m = Partitioning.med3(m - s, m, m + s, comp2);
                    n = Partitioning.med3(n - 2 * s, n - s, n, comp2);
                }
                m = Partitioning.med3(l, m, n, comp2);
            }
            if ((medianIndex = Partitioning.binarySearchFromTo(m, splitFrom, splitTo, comp)) < 0) {
                medianIndex = -medianIndex - 1;
            }
            if (medianIndex > splitTo) {
                medianIndex = splitTo;
            }
        }
        int splitter = medianIndex;
        splitIndexes[medianIndex] = splitIndex = Partitioning.genericPartition(from, to, splitter, comp, swapper);
        if (splitIndex < from) {
            i = medianIndex - 1;
            while (i >= splitFrom && comp3.compare(splitter, i) >= 0) {
                splitIndexes[i--] = splitIndex;
            }
            splitFrom = medianIndex + 1;
        } else if (splitIndex >= to) {
            i = medianIndex + 1;
            while (i <= splitTo && comp3.compare(splitter, i) <= 0) {
                splitIndexes[i++] = splitIndex;
            }
            splitTo = medianIndex - 1;
        }
        if (splitFrom <= medianIndex - 1) {
            Partitioning.genericPartition(from, splitIndex, splitFrom, medianIndex - 1, splitIndexes, comp, comp2, comp3, swapper);
        }
        if (medianIndex + 1 <= splitTo) {
            Partitioning.genericPartition(splitIndex + 1, to, medianIndex + 1, splitTo, splitIndexes, comp, comp2, comp3, swapper);
        }
    }

    private static int genericPartition(int from, int to, int splitter, IntComparator comp, Swapper swapper) {
        int i = from - 1;
        while (++i <= to) {
            if (comp.compare(splitter, i) <= 0) continue;
            swapper.swap(i, from);
            ++from;
        }
        return from - 1;
    }

    private static int med3(double[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static int med3(int[] x, int a, int b, int c) {
        return x[a] < x[b] ? (x[b] < x[c] ? b : (x[a] < x[c] ? c : a)) : (x[b] > x[c] ? b : (x[a] > x[c] ? c : a));
    }

    private static int med3(Object[] x, int a, int b, int c, Comparator<Object> comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static int med3(int a, int b, int c, IntComparator comp) {
        int ab = comp.compare(a, b);
        int ac = comp.compare(a, c);
        int bc = comp.compare(b, c);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void partition(double[] list, int from, int to, double[] splitters, int splitFrom, int splitTo, int[] splitIndexes) {
        int i;
        int splitIndex;
        int medianIndex;
        if (splitFrom > splitTo) {
            return;
        }
        if (from > to) {
            --from;
            int i2 = splitFrom;
            while (i2 <= splitTo) {
                splitIndexes[i2++] = from;
            }
            return;
        }
        if (splitFrom == splitTo) {
            medianIndex = splitFrom;
        } else {
            int m = (from + to) / 2;
            int len = to - from + 1;
            if (len > 7) {
                int l = from;
                int n = to;
                if (len > 40) {
                    int s = len / 8;
                    l = Partitioning.med3(list, l, l + s, l + 2 * s);
                    m = Partitioning.med3(list, m - s, m, m + s);
                    n = Partitioning.med3(list, n - 2 * s, n - s, n);
                }
                m = Partitioning.med3(list, l, m, n);
            }
            if ((medianIndex = Sorting.binarySearchFromTo((double[])splitters, (double)list[m], (int)splitFrom, (int)splitTo)) < 0) {
                medianIndex = -medianIndex - 1;
            }
            if (medianIndex > splitTo) {
                medianIndex = splitTo;
            }
        }
        double splitter = splitters[medianIndex];
        splitIndexes[medianIndex] = splitIndex = Partitioning.partition(list, from, to, splitter);
        if (splitIndex < from) {
            i = medianIndex - 1;
            while (i >= splitFrom && !(splitter < splitters[i])) {
                splitIndexes[i--] = splitIndex;
            }
            splitFrom = medianIndex + 1;
        } else if (splitIndex >= to) {
            i = medianIndex + 1;
            while (i <= splitTo && !(splitter > splitters[i])) {
                splitIndexes[i++] = splitIndex;
            }
            splitTo = medianIndex - 1;
        }
        if (splitFrom <= medianIndex - 1) {
            Partitioning.partition(list, from, splitIndex, splitters, splitFrom, medianIndex - 1, splitIndexes);
        }
        if (medianIndex + 1 <= splitTo) {
            Partitioning.partition(list, splitIndex + 1, to, splitters, medianIndex + 1, splitTo, splitIndexes);
        }
    }

    public static int partition(double[] list, int from, int to, double splitter) {
        int i = from - 1;
        while (++i <= to) {
            double element = list[i];
            if (!(element < splitter)) continue;
            list[i] = list[from];
            list[from++] = element;
        }
        return from - 1;
    }

    public static void partition(int[] list, int from, int to, int[] splitters, int splitFrom, int splitTo, int[] splitIndexes) {
        int i;
        int splitIndex;
        int medianIndex;
        if (splitFrom > splitTo) {
            return;
        }
        if (from > to) {
            --from;
            int i2 = splitFrom;
            while (i2 <= splitTo) {
                splitIndexes[i2++] = from;
            }
            return;
        }
        if (splitFrom == splitTo) {
            medianIndex = splitFrom;
        } else {
            int m = (from + to) / 2;
            int len = to - from + 1;
            if (len > 7) {
                int l = from;
                int n = to;
                if (len > 40) {
                    int s = len / 8;
                    l = Partitioning.med3(list, l, l + s, l + 2 * s);
                    m = Partitioning.med3(list, m - s, m, m + s);
                    n = Partitioning.med3(list, n - 2 * s, n - s, n);
                }
                m = Partitioning.med3(list, l, m, n);
            }
            if ((medianIndex = Sorting.binarySearchFromTo((int[])splitters, (int)list[m], (int)splitFrom, (int)splitTo)) < 0) {
                medianIndex = -medianIndex - 1;
            }
            if (medianIndex > splitTo) {
                medianIndex = splitTo;
            }
        }
        int splitter = splitters[medianIndex];
        splitIndexes[medianIndex] = splitIndex = Partitioning.partition(list, from, to, splitter);
        if (splitIndex < from) {
            i = medianIndex - 1;
            while (i >= splitFrom && splitter >= splitters[i]) {
                splitIndexes[i--] = splitIndex;
            }
            splitFrom = medianIndex + 1;
        } else if (splitIndex >= to) {
            i = medianIndex + 1;
            while (i <= splitTo && splitter <= splitters[i]) {
                splitIndexes[i++] = splitIndex;
            }
            splitTo = medianIndex - 1;
        }
        if (splitFrom <= medianIndex - 1) {
            Partitioning.partition(list, from, splitIndex, splitters, splitFrom, medianIndex - 1, splitIndexes);
        }
        if (medianIndex + 1 <= splitTo) {
            Partitioning.partition(list, splitIndex + 1, to, splitters, medianIndex + 1, splitTo, splitIndexes);
        }
    }

    public static int partition(int[] list, int from, int to, int splitter) {
        steps += to - from + 1;
        int i = from - 1;
        while (++i <= to) {
            int element = list[i];
            if (element >= splitter) continue;
            list[i] = list[from];
            list[from++] = element;
        }
        return from - 1;
    }

    public static void partition(Object[] list, int from, int to, Object[] splitters, int splitFrom, int splitTo, int[] splitIndexes, Comparator<Object> comp) {
        int i;
        int splitIndex;
        int medianIndex;
        if (splitFrom > splitTo) {
            return;
        }
        if (from > to) {
            --from;
            int i2 = splitFrom;
            while (i2 <= splitTo) {
                splitIndexes[i2++] = from;
            }
            return;
        }
        if (splitFrom == splitTo) {
            medianIndex = splitFrom;
        } else {
            int m = (from + to) / 2;
            int len = to - from + 1;
            if (len > 7) {
                int l = from;
                int n = to;
                if (len > 40) {
                    int s = len / 8;
                    l = Partitioning.med3(list, l, l + s, l + 2 * s, comp);
                    m = Partitioning.med3(list, m - s, m, m + s, comp);
                    n = Partitioning.med3(list, n - 2 * s, n - s, n, comp);
                }
                m = Partitioning.med3(list, l, m, n, comp);
            }
            if ((medianIndex = Sorting.binarySearchFromTo((Object[])splitters, (Object)list[m], (int)splitFrom, (int)splitTo, comp)) < 0) {
                medianIndex = -medianIndex - 1;
            }
            if (medianIndex > splitTo) {
                medianIndex = splitTo;
            }
        }
        Object splitter = splitters[medianIndex];
        splitIndexes[medianIndex] = splitIndex = Partitioning.partition(list, from, to, splitter, comp);
        if (splitIndex < from) {
            i = medianIndex - 1;
            while (i >= splitFrom && comp.compare(splitter, splitters[i]) >= 0) {
                splitIndexes[i--] = splitIndex;
            }
            splitFrom = medianIndex + 1;
        } else if (splitIndex >= to) {
            i = medianIndex + 1;
            while (i <= splitTo && comp.compare(splitter, splitters[i]) <= 0) {
                splitIndexes[i++] = splitIndex;
            }
            splitTo = medianIndex - 1;
        }
        if (splitFrom <= medianIndex - 1) {
            Partitioning.partition(list, from, splitIndex, splitters, splitFrom, medianIndex - 1, splitIndexes, comp);
        }
        if (medianIndex + 1 <= splitTo) {
            Partitioning.partition(list, splitIndex + 1, to, splitters, medianIndex + 1, splitTo, splitIndexes, comp);
        }
    }

    public static int partition(Object[] list, int from, int to, Object splitter, Comparator<Object> comp) {
        int i = from - 1;
        while (++i <= to) {
            Object element = list[i];
            if (comp.compare(element, splitter) >= 0) continue;
            list[i] = list[from];
            list[from] = element;
            ++from;
        }
        return from - 1;
    }

    public static void partition(DoubleArrayList list, int from, int to, DoubleArrayList splitters, IntArrayList splitIndexes) {
        Partitioning.partition(list.elements(), from, to, splitters.elements(), 0, splitters.size() - 1, splitIndexes.elements());
    }

    public static void partition(IntArrayList list, int from, int to, IntArrayList splitters, IntArrayList splitIndexes) {
        Partitioning.partition(list.elements(), from, to, splitters.elements(), 0, splitters.size() - 1, splitIndexes.elements());
    }

    public static void triplePartition(double[] list, double[] secondary, double[] tertiary, int from, int to, double[] splitters, int splitFrom, int splitTo, int[] splitIndexes) {
        int i;
        int splitIndex;
        int medianIndex;
        if (splitFrom > splitTo) {
            return;
        }
        if (from > to) {
            --from;
            int i2 = splitFrom;
            while (i2 <= splitTo) {
                splitIndexes[i2++] = from;
            }
            return;
        }
        if (splitFrom == splitTo) {
            medianIndex = splitFrom;
        } else {
            int m = (from + to) / 2;
            int len = to - from + 1;
            if (len > 7) {
                int l = from;
                int n = to;
                if (len > 40) {
                    int s = len / 8;
                    l = Partitioning.med3(list, l, l + s, l + 2 * s);
                    m = Partitioning.med3(list, m - s, m, m + s);
                    n = Partitioning.med3(list, n - 2 * s, n - s, n);
                }
                m = Partitioning.med3(list, l, m, n);
            }
            if ((medianIndex = Sorting.binarySearchFromTo((double[])splitters, (double)list[m], (int)splitFrom, (int)splitTo)) < 0) {
                medianIndex = -medianIndex - 1;
            }
            if (medianIndex > splitTo) {
                medianIndex = splitTo;
            }
        }
        double splitter = splitters[medianIndex];
        splitIndexes[medianIndex] = splitIndex = Partitioning.triplePartition(list, secondary, tertiary, from, to, splitter);
        if (splitIndex < from) {
            i = medianIndex - 1;
            while (i >= splitFrom && !(splitter < splitters[i])) {
                splitIndexes[i--] = splitIndex;
            }
            splitFrom = medianIndex + 1;
        } else if (splitIndex >= to) {
            i = medianIndex + 1;
            while (i <= splitTo && !(splitter > splitters[i])) {
                splitIndexes[i++] = splitIndex;
            }
            splitTo = medianIndex - 1;
        }
        if (splitFrom <= medianIndex - 1) {
            Partitioning.triplePartition(list, secondary, tertiary, from, splitIndex, splitters, splitFrom, medianIndex - 1, splitIndexes);
        }
        if (medianIndex + 1 <= splitTo) {
            Partitioning.triplePartition(list, secondary, tertiary, splitIndex + 1, to, splitters, medianIndex + 1, splitTo, splitIndexes);
        }
    }

    public static int triplePartition(double[] list, double[] secondary, double[] tertiary, int from, int to, double splitter) {
        int i = from - 1;
        while (++i <= to) {
            double element = list[i];
            if (!(element < splitter)) continue;
            list[i] = list[from];
            list[from] = element;
            element = secondary[i];
            secondary[i] = secondary[from];
            secondary[from] = element;
            element = tertiary[i];
            tertiary[i] = tertiary[from];
            tertiary[from++] = element;
        }
        return from - 1;
    }

    public static void triplePartition(int[] list, int[] secondary, int[] tertiary, int from, int to, int[] splitters, int splitFrom, int splitTo, int[] splitIndexes) {
        int i;
        int splitIndex;
        int medianIndex;
        if (splitFrom > splitTo) {
            return;
        }
        if (from > to) {
            --from;
            int i2 = splitFrom;
            while (i2 <= splitTo) {
                splitIndexes[i2++] = from;
            }
            return;
        }
        if (splitFrom == splitTo) {
            medianIndex = splitFrom;
        } else {
            int m = (from + to) / 2;
            int len = to - from + 1;
            if (len > 7) {
                int l = from;
                int n = to;
                if (len > 40) {
                    int s = len / 8;
                    l = Partitioning.med3(list, l, l + s, l + 2 * s);
                    m = Partitioning.med3(list, m - s, m, m + s);
                    n = Partitioning.med3(list, n - 2 * s, n - s, n);
                }
                m = Partitioning.med3(list, l, m, n);
            }
            if ((medianIndex = Sorting.binarySearchFromTo((int[])splitters, (int)list[m], (int)splitFrom, (int)splitTo)) < 0) {
                medianIndex = -medianIndex - 1;
            }
            if (medianIndex > splitTo) {
                medianIndex = splitTo;
            }
        }
        int splitter = splitters[medianIndex];
        splitIndexes[medianIndex] = splitIndex = Partitioning.triplePartition(list, secondary, tertiary, from, to, splitter);
        if (splitIndex < from) {
            i = medianIndex - 1;
            while (i >= splitFrom && splitter >= splitters[i]) {
                splitIndexes[i--] = splitIndex;
            }
            splitFrom = medianIndex + 1;
        } else if (splitIndex >= to) {
            i = medianIndex + 1;
            while (i <= splitTo && splitter <= splitters[i]) {
                splitIndexes[i++] = splitIndex;
            }
            splitTo = medianIndex - 1;
        }
        if (splitFrom <= medianIndex - 1) {
            Partitioning.triplePartition(list, secondary, tertiary, from, splitIndex, splitters, splitFrom, medianIndex - 1, splitIndexes);
        }
        if (medianIndex + 1 <= splitTo) {
            Partitioning.triplePartition(list, secondary, tertiary, splitIndex + 1, to, splitters, medianIndex + 1, splitTo, splitIndexes);
        }
    }

    public static int triplePartition(int[] list, int[] secondary, int[] tertiary, int from, int to, int splitter) {
        int i = from - 1;
        while (++i <= to) {
            int element = list[i];
            if (element >= splitter) continue;
            list[i] = list[from];
            list[from] = element;
            element = secondary[i];
            secondary[i] = secondary[from];
            secondary[from] = element;
            element = tertiary[i];
            tertiary[i] = tertiary[from];
            tertiary[from++] = element;
        }
        return from - 1;
    }
}

