/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Root(name="value-set")
public class AttributeValueSet {
    @Element
    public String label;
    @Element(required=false)
    public String description;
    Map<String, Object> overridenAttributeValues;
    AttributeValueSet baseAttributeValueSet;
    @Attribute(name="based-on", required=false)
    String baseAttributeValueSetId;
    @ElementMap(entry="attribute", key="key", attribute=true, inline=true, required=false)
    private TreeMap<String, SimpleXmlWrapperValue> overridenAttributeValuesForSerialization;

    AttributeValueSet() {
    }

    public AttributeValueSet(String label) {
        this(label, null);
    }

    public AttributeValueSet(String label, AttributeValueSet base) {
        this(label, null, base);
    }

    public AttributeValueSet(String label, String description, AttributeValueSet base) {
        this.label = label;
        this.description = description;
        this.baseAttributeValueSet = base;
        this.overridenAttributeValues = Maps.newHashMap();
    }

    public Object getAttributeValue(String key) {
        if (this.overridenAttributeValues.containsKey(key)) {
            return this.overridenAttributeValues.get(key);
        }
        if (this.baseAttributeValueSet != null) {
            return this.baseAttributeValueSet.getAttributeValue(key);
        }
        return null;
    }

    public Map<String, Object> getAttributeValues() {
        HashMap result = Maps.newHashMap();
        if (this.baseAttributeValueSet != null) {
            result.putAll(this.baseAttributeValueSet.getAttributeValues());
        }
        result.putAll(this.overridenAttributeValues);
        return result;
    }

    public Object setAttributeValue(String key, Object value) {
        return this.overridenAttributeValues.put(key, value);
    }

    public void setAttributeValues(Map<String, Object> values) {
        this.overridenAttributeValues.putAll(values);
    }

    public static Map<String, Object> getAttributeValues(AttributeValueSet attributeValueSet) {
        return attributeValueSet != null ? attributeValueSet.getAttributeValues() : null;
    }

    @Persist
    private void convertAttributeValuesToStrings() {
        this.overridenAttributeValuesForSerialization = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        this.overridenAttributeValuesForSerialization.putAll(SimpleXmlWrappers.wrap(this.overridenAttributeValues));
    }

    @Commit
    private void convertAttributeValuesFromStrings() throws Exception {
        this.overridenAttributeValues = this.overridenAttributeValuesForSerialization == null ? Maps.newHashMap() : SimpleXmlWrappers.unwrap(this.overridenAttributeValuesForSerialization);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributeValueSet [");
        boolean first = true;
        for (Map.Entry<String, Object> e : this.getAttributeValues().entrySet()) {
            if (!first) {
                b.append(", ");
            }
            b.append(e.getKey() != null ? e.getKey() : "null");
            b.append('=');
            b.append(e.getValue() != null ? e.getValue().toString() : "null");
            first = false;
        }
        b.append("]");
        return b.toString();
    }
}

