/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.opensearch;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.MultipageSearchEngineDescriptor;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenSearchDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.opensearch.OpenSearchDocumentSource";
    public final String prefix = "OpenSearchDocumentSource";
    public final String title = "A <code>IDocumentSource</code> fetching <code>Document</code>s (search results) from an OpenSearch feed";
    public final String label = "";
    public final String description = "<p> Based on code donated by Julien Nioche.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "OpenSearchDocumentSource";
    }

    @Override
    public String getTitle() {
        return "A <code>IDocumentSource</code> fetching <code>Document</code>s (search results) from an OpenSearch feed";
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public String getDescription() {
        return "<p> Based on code donated by Julien Nioche.";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(OpenSearchDocumentSourceDescriptor.attributes.feedUrlTemplate);
        ownAttrs.add(OpenSearchDocumentSourceDescriptor.attributes.resultsPerPage);
        ownAttrs.add(OpenSearchDocumentSourceDescriptor.attributes.maximumResults);
        ownAttrs.add(OpenSearchDocumentSourceDescriptor.attributes.feedUrlParams);
        ownAttrs.add(OpenSearchDocumentSourceDescriptor.attributes.userAgent);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(OpenSearchDocumentSourceDescriptor.attributes.feedUrlTemplate);
        allAttrs.add(OpenSearchDocumentSourceDescriptor.attributes.resultsPerPage);
        allAttrs.add(OpenSearchDocumentSourceDescriptor.attributes.maximumResults);
        allAttrs.add(OpenSearchDocumentSourceDescriptor.attributes.feedUrlParams);
        allAttrs.add(OpenSearchDocumentSourceDescriptor.attributes.userAgent);
        allAttrs.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.start);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.results);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.query);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.documents);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.compressed);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder
    extends MultipageSearchEngineDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder feedUrlTemplate(String value) {
            this.map.put("OpenSearchDocumentSource.feedUrlTemplate", value);
            return this;
        }

        public AttributeBuilder resultsPerPage(int value) {
            this.map.put("OpenSearchDocumentSource.resultsPerPage", value);
            return this;
        }

        public AttributeBuilder maximumResults(int value) {
            this.map.put("OpenSearchDocumentSource.maximumResults", value);
            return this;
        }

        public AttributeBuilder feedUrlParams(Map<String, String> value) {
            this.map.put("OpenSearchDocumentSource.feedUrlParams", value);
            return this;
        }

        public AttributeBuilder userAgent(String value) {
            this.map.put("OpenSearchDocumentSource.userAgent", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo feedUrlTemplate = new AttributeInfo("OpenSearchDocumentSource.feedUrlTemplate", "org.carrot2.source.opensearch.OpenSearchDocumentSource", "feedUrlTemplate", "URL to fetch the search feed from. The URL template can contain variable place\nholders as defined by the OpenSearch specification that will be replaced during\nruntime. The format of the place holder is <code>${variable}</code>. The following\nvariables are supported:\n<ul>\n<li><code>searchTerms</code> will be replaced by the query</li> <li><code>\nstartIndex</code> index of the first result to be searched. Mutually exclusive with\n<code>startPage</code></li>. <li><code>startPage</code> index of the first result\nto be searched. Mutually exclusive with <code>startIndex</code>.</li><li><code>\ncount</code> the number of search results per page</li>\n</ul>\n<p>\nExample URL feed templates for public services:\n<dl>\n<dt>nature.com</dt>\n<dd><code>http://www.nature.com/opensearch/request?interface=opensearch&amp;operation=searchRetrieve&amp;query=${searchTerms}&amp;startRecord=${startIndex}&amp;maximumRecords=${count}&amp;httpAccept=application/rss%2Bxml</code></dd>\n<dt>indeed.com</dt>\n<dd><code>http://www.indeed.com/opensearch?q=${searchTerms}&amp;start=${startIndex}&amp;limit=${count}</code></dd>\n</dl>\n\n</p>", "Feed URL template", "URL to fetch the search feed from", "The URL template can contain variable place holders as defined by the OpenSearch specification that will be replaced during runtime. The format of the place holder is <code>${variable}</code>. The following variables are supported: <ul> <li><code>searchTerms</code> will be replaced by the query</li> <li><code> startIndex</code> index of the first result to be searched. Mutually exclusive with <code>startPage</code></li>. <li><code>startPage</code> index of the first result to be searched. Mutually exclusive with <code>startIndex</code>.</li><li><code> count</code> the number of search results per page</li> </ul> <p> Example URL feed templates for public services: <dl> <dt>nature.com</dt> <dd><code>http://www.nature.com/opensearch/request?interface=opensearch&amp;operation=searchRetrieve&amp;query=${searchTerms}&amp;startRecord=${startIndex}&amp;maximumRecords=${count}&amp;httpAccept=application/rss%2Bxml</code></dd> <dt>indeed.com</dt> <dd><code>http://www.indeed.com/opensearch?q=${searchTerms}&amp;start=${startIndex}&amp;limit=${count}</code></dd> </dl> </p>", "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo resultsPerPage = new AttributeInfo("OpenSearchDocumentSource.resultsPerPage", "org.carrot2.source.opensearch.OpenSearchDocumentSource", "resultsPerPage", "Results per page. The number of results per page the document source will expect\nthe feed to return.", "Results per page", "Results per page", "The number of results per page the document source will expect the feed to return.", "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo maximumResults = new AttributeInfo("OpenSearchDocumentSource.maximumResults", "org.carrot2.source.opensearch.OpenSearchDocumentSource", "maximumResults", "Maximum number of results. The maximum number of results the document source can\ndeliver.", "Maximum results", "Maximum number of results", "The maximum number of results the document source can deliver.", "Service", AttributeLevel.BASIC, null);
        public final AttributeInfo feedUrlParams = new AttributeInfo("OpenSearchDocumentSource.feedUrlParams", "org.carrot2.source.opensearch.OpenSearchDocumentSource", "feedUrlParams", "Additional parameters to be appended to {@link org.carrot2.source.opensearch.OpenSearchDocumentSource#feedUrlTemplate} on each request.", "Feed URL parameters", "Additional parameters to be appended to <code>org.carrot2.source.opensearch.OpenSearchDocumentSource.feedUrlTemplate</code> on each request", null, "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo userAgent = new AttributeInfo("OpenSearchDocumentSource.userAgent", "org.carrot2.source.opensearch.OpenSearchDocumentSource", "userAgent", "User agent header. The contents of the User-Agent HTTP header to use when making\nrequests to the feed URL. If empty or <code>null</code> value is provided,\nthe following User-Agent will be sent: <code>Rome Client (http://tinyurl.com/64t5n) \nVer: UNKNOWN</code>.", "User agent", "User agent header", "The contents of the User-Agent HTTP header to use when making requests to the feed URL. If empty or <code>null</code> value is provided, the following User-Agent will be sent: <code>Rome Client (http://tinyurl.com/64t5n) Ver: UNKNOWN</code>.", "Service", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends MultipageSearchEngineDescriptor.Keys {
        public static final String FEED_URL_TEMPLATE = "OpenSearchDocumentSource.feedUrlTemplate";
        public static final String RESULTS_PER_PAGE = "OpenSearchDocumentSource.resultsPerPage";
        public static final String MAXIMUM_RESULTS = "OpenSearchDocumentSource.maximumResults";
        public static final String FEED_URL_PARAMS = "OpenSearchDocumentSource.feedUrlParams";
        public static final String USER_AGENT = "OpenSearchDocumentSource.userAgent";

        protected Keys() {
        }
    }
}

