/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.microsoft;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.MultipageSearchEngineDescriptor;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.source.microsoft.AdultOption;
import org.carrot2.source.microsoft.MarketOption;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BingDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.microsoft.BingDocumentSource";
    public final String prefix = "BingDocumentSource";
    public final String title = "A <code>IDocumentSource</code> fetching <code>Document</code>s (search results) from Microsoft Bing API";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "BingDocumentSource";
    }

    @Override
    public String getTitle() {
        return "A <code>IDocumentSource</code> fetching <code>Document</code>s (search results) from Microsoft Bing API";
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(BingDocumentSourceDescriptor.attributes.appid);
        ownAttrs.add(BingDocumentSourceDescriptor.attributes.market);
        ownAttrs.add(BingDocumentSourceDescriptor.attributes.adult);
        ownAttrs.add(BingDocumentSourceDescriptor.attributes.options);
        ownAttrs.add(BingDocumentSourceDescriptor.attributes.webOptions);
        ownAttrs.add(BingDocumentSourceDescriptor.attributes.fileTypes);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(BingDocumentSourceDescriptor.attributes.appid);
        allAttrs.add(BingDocumentSourceDescriptor.attributes.market);
        allAttrs.add(BingDocumentSourceDescriptor.attributes.adult);
        allAttrs.add(BingDocumentSourceDescriptor.attributes.options);
        allAttrs.add(BingDocumentSourceDescriptor.attributes.webOptions);
        allAttrs.add(BingDocumentSourceDescriptor.attributes.fileTypes);
        allAttrs.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.start);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.results);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.query);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.documents);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.compressed);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder
    extends MultipageSearchEngineDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder appid(String value) {
            this.map.put("BingDocumentSource.appid", value);
            return this;
        }

        public AttributeBuilder market(MarketOption value) {
            this.map.put("BingDocumentSource.market", (Object)value);
            return this;
        }

        public AttributeBuilder market(Class<? extends MarketOption> clazz) {
            this.map.put("BingDocumentSource.market", clazz);
            return this;
        }

        public AttributeBuilder adult(AdultOption value) {
            this.map.put("BingDocumentSource.adult", (Object)value);
            return this;
        }

        public AttributeBuilder adult(Class<? extends AdultOption> clazz) {
            this.map.put("BingDocumentSource.adult", clazz);
            return this;
        }

        public AttributeBuilder options(String value) {
            this.map.put("BingDocumentSource.options", value);
            return this;
        }

        public AttributeBuilder webOptions(String value) {
            this.map.put("BingDocumentSource.webOptions", value);
            return this;
        }

        public AttributeBuilder fileTypes(String value) {
            this.map.put("BingDocumentSource.fileTypes", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo appid = new AttributeInfo("BingDocumentSource.appid", "org.carrot2.source.microsoft.BingDocumentSource", "appid", "Microsoft-assigned application ID for querying the API. Please <strong>generate\nyour own ID</strong> for production deployments and branches off the Carrot2.org's\ncode.", "Application ID", "Microsoft-assigned application ID for querying the API", "Please <strong>generate your own ID</strong> for production deployments and branches off the Carrot2.org's code.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo market = new AttributeInfo("BingDocumentSource.market", "org.carrot2.source.microsoft.BingDocumentSource", "market", "Language and country/region information for the request.", "Market", "Language and country/region information for the request", null, "Results filtering", AttributeLevel.BASIC, null);
        public final AttributeInfo adult = new AttributeInfo("BingDocumentSource.adult", "org.carrot2.source.microsoft.BingDocumentSource", "adult", "Adult search restriction (porn filter).", "Safe Search", "Adult search restriction (porn filter)", null, "Results filtering", AttributeLevel.MEDIUM, null);
        public final AttributeInfo options = new AttributeInfo("BingDocumentSource.options", "org.carrot2.source.microsoft.BingDocumentSource", "options", "Miscellaneous request options. Bing provides the following options:\n<ul>\n<li>DisableLocationDetection</li>\n<li>EnableHighlighting</li>\n</ul>\n\n<p>Options should be space-separated.</p>", "Request Options", "Miscellaneous request options", "Bing provides the following options: <ul> <li>DisableLocationDetection</li> <li>EnableHighlighting</li> </ul> <p>Options should be space-separated.</p>", "Miscellaneous", AttributeLevel.ADVANCED, null);
        public final AttributeInfo webOptions = new AttributeInfo("BingDocumentSource.webOptions", "org.carrot2.source.microsoft.BingDocumentSource", "webOptions", "Miscellaneous Web-request specific options. Bing provides the following options:\n<ul>\n<li>DisableHostCollapsing</li>\n<li>DisableQueryAlterations</li>\n</ul>\n\n<p>Options should be space-separated.</p>", "Web Request Options", "Miscellaneous Web-request specific options", "Bing provides the following options: <ul> <li>DisableHostCollapsing</li> <li>DisableQueryAlterations</li> </ul> <p>Options should be space-separated.</p>", "Miscellaneous", AttributeLevel.ADVANCED, null);
        public final AttributeInfo fileTypes = new AttributeInfo("BingDocumentSource.fileTypes", "org.carrot2.source.microsoft.BingDocumentSource", "fileTypes", "Specify the allowed file types. Space-separated list of file extensions (upper-case). \nSee <a href=\"http://msdn.microsoft.com/en-us/library/dd250876%28v=MSDN.10%29.aspx\">Bing documentation</a>.", "File Types", "Specify the allowed file types", "Space-separated list of file extensions (upper-case). See <a href=\"http://msdn.microsoft.com/en-us/library/dd250876%28v=MSDN.10%29.aspx\">Bing documentation</a>.", "Results filtering", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends MultipageSearchEngineDescriptor.Keys {
        public static final String APPID = "BingDocumentSource.appid";
        public static final String MARKET = "BingDocumentSource.market";
        public static final String ADULT = "BingDocumentSource.adult";
        public static final String OPTIONS = "BingDocumentSource.options";
        public static final String WEB_OPTIONS = "BingDocumentSource.webOptions";
        public static final String FILE_TYPES = "BingDocumentSource.fileTypes";

        protected Keys() {
        }
    }
}

