/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.text.AnnotationFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subiterator<T extends AnnotationFS>
extends FSIteratorImplBase<T> {
    private ArrayList<T> list = new ArrayList();
    private int pos = 0;
    private Comparator<FeatureStructure> annotationComparator = null;

    private Subiterator() {
    }

    Subiterator(FSIterator<T> it) {
        this();
        it.moveToFirst();
        if (!it.isValid()) {
            return;
        }
        AnnotationFS current = (AnnotationFS)it.get();
        this.list.add(current);
        it.moveToNext();
        while (it.isValid()) {
            AnnotationFS next = (AnnotationFS)it.get();
            if (current.getEnd() <= next.getBegin()) {
                current = next;
                this.list.add(current);
            }
            it.moveToNext();
        }
    }

    Subiterator(FSIterator<T> it, AnnotationFS annot, boolean ambiguous, boolean strict) {
        this();
        if (ambiguous) {
            super.initAmbiguousSubiterator(it, annot, strict);
        } else {
            super.initUnambiguousSubiterator(it, annot, strict);
        }
    }

    private void initAmbiguousSubiterator(FSIterator<T> it, AnnotationFS annot, boolean strict) {
        AnnotationFS current;
        int start = annot.getBegin();
        int end = annot.getEnd();
        it.moveTo(annot);
        if (it.isValid() && ((AnnotationFS)it.get()).equals(annot)) {
            it.moveToNext();
        }
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() < start) {
            it.moveToNext();
        }
        while (it.isValid() && (current = (AnnotationFS)it.get()).getBegin() <= end) {
            it.moveToNext();
            if (strict && current.getEnd() > end) continue;
            this.list.add(current);
        }
    }

    private void initUnambiguousSubiterator(FSIterator<T> it, AnnotationFS annot, boolean strict) {
        int start = annot.getBegin();
        int end = annot.getEnd();
        it.moveTo(annot);
        if (it.isValid() && ((AnnotationFS)it.get()).equals(annot)) {
            it.moveToNext();
        }
        if (!it.isValid()) {
            return;
        }
        annot = (AnnotationFS)it.get();
        this.list = new ArrayList();
        while (it.isValid() && (start > annot.getBegin() || strict && annot.getEnd() > end)) {
            it.moveToNext();
        }
        if (!it.isValid()) {
            return;
        }
        AnnotationFS current = (AnnotationFS)it.get();
        this.list.add(current);
        it.moveToNext();
        while (it.isValid()) {
            AnnotationFS next = (AnnotationFS)it.get();
            if (next.getBegin() < current.getEnd()) {
                it.moveToNext();
                continue;
            }
            if (next.getBegin() > end) break;
            if (!strict || next.getEnd() <= end) {
                current = next;
                this.list.add(current);
            }
            it.moveToNext();
        }
    }

    @Override
    public boolean isValid() {
        return this.pos >= 0 && this.pos < this.list.size();
    }

    @Override
    public T get() throws NoSuchElementException {
        if (this.isValid()) {
            return (T)((AnnotationFS)this.list.get(this.pos));
        }
        throw new NoSuchElementException();
    }

    @Override
    public void moveToNext() {
        ++this.pos;
    }

    @Override
    public void moveToPrevious() {
        --this.pos;
    }

    @Override
    public void moveToFirst() {
        this.pos = 0;
    }

    @Override
    public void moveToLast() {
        this.pos = this.list.size() - 1;
    }

    private final Comparator<FeatureStructure> getAnnotationComparator(FeatureStructure fs) {
        if (this.annotationComparator == null) {
            this.annotationComparator = new FSIteratorImplBase.AnnotationComparator<FeatureStructure>(fs.getCAS().getAnnotationIndex());
        }
        return this.annotationComparator;
    }

    @Override
    public void moveTo(FeatureStructure fs) {
        int found = Collections.binarySearch(this.list, fs, this.getAnnotationComparator(fs));
        this.pos = found >= 0 ? found : -found - 1;
    }

    @Override
    public FSIterator<T> copy() {
        Subiterator<T> copy = new Subiterator<T>();
        copy.list = this.list;
        copy.pos = this.pos;
        return copy;
    }
}

